/*

  Library: LocoNet
  File:    LnPowerControl
  Descr:   ...
  By:      Ed den Ouden 2022 DCC-Edd (public domain)
  Remark:  Loconet cables are twisted internally


  Digitrax cable colors:

  1  wit    railsync-b  7v dc
  2  zwart  gnd         -
  3  rood   loconet     14,5v dc
  4  groen  oloconet    14,5v dc
  5  geel   gnd         -
  6  blauw  railsync-a  7v dc


  Rocrail settings:

  ...
  ...

*/

#include <LocoNet.h>

#define BUTTON_PIN  2

bool isPowerOn = false;
bool buttonWasDown = false;

void setup() {

  LocoNet.init();
  pinMode(BUTTON_PIN, INPUT_PULLUP);
}


void loop() {

  // button pressed
  if(digitalRead(BUTTON_PIN) == LOW && !buttonWasDown) {

    // toggle power status
    if(isPowerOn) {
      LocoNet.reportPower(0);
      isPowerOn = false;
    } else {
      LocoNet.reportPower(1);
      isPowerOn = true;      
    }
    buttonWasDown = true;
  }

  // button released
  else if(digitalRead(BUTTON_PIN) == HIGH && buttonWasDown)
    buttonWasDown = false;
}
