/*

  Library: LocoNet
  File:    LnPowerStatus
  Descr:   ...
  By:      Ed den Ouden 2022 DCC-Edd (public domain)
  Remark:  Loconet cables are twisted internally


  Digitrax cable colors:

  1  wit    railsync-b  7v dc
  2  zwart  gnd         -
  3  rood   loconet     14,5v dc
  4  groen  oloconet    14,5v dc
  5  geel   gnd         -
  6  blauw  railsync-a  7v dc


  Rocrail settings:

  ...
  ...

*/

#include <LocoNet.h>

#define LED_PIN  2

void setup() {

  LocoNet.init();
  pinMode(LED_PIN, OUTPUT);
}


void loop() {

  lnMsg *LnPacket = LocoNet.receive();
  if(LnPacket) LocoNet.processSwitchSensorMessage(LnPacket);
}

void notifyPower(uint8_t State) {

    if(State == 1) digitalWrite(LED_PIN, HIGH);
    else digitalWrite(LED_PIN, LOW);
}
