/*

  Library: LocoNet
  File:    LocoBuffer
  Descr:   Loconet master interface
  By:      Ed den Ouden 2022 DCC-Edd (public domain)
  Remark:  Loconet cables are twisted internally


  Digitrax cable colors:

  1  wit    railsync-b  7v dc
  2  zwart  gnd         -
  3  rood   loconet     14,5v dc
  4  groen  oloconet    14,5v dc
  5  geel   gnd         -
  6  blauw  railsync-a  7v dc


  Rocrail settings:

  ...
  ...

*/

#include <LocoNet.h>

lnMsg *LnPacket;
LnBuf LnTxBuffer;

void setup() {
  // First initialize the LocoNet interface
  LocoNet.init();

  // Configure the serial port for 19200 baud
  Serial.begin(19200);
}

void loop() {

  // check for packets coming from the Loconet bus
  LnPacket = LocoNet.receive();

  if (LnPacket) {
    uint8_t msgLen = getLnMsgSize(LnPacket);
    for (uint8_t x = 0; x < msgLen; x++)
      Serial.write(LnPacket->data[x]);
  }


  // check for packets coming from the serial port
  if (Serial.available()) {

    uint8_t inByte = Serial.read() & 0xFF;
    addByteLnBuf(&LnTxBuffer, inByte);

    LnPacket = recvLnMsg( &LnTxBuffer );
    if (LnPacket) LocoNet.send(LnPacket);
  }
}
